unit Cbtests;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CB_Gdi, CB3Party, StdCtrls, Printers, CB_MFunc;

type
  TWPrintMes = record
    Msg: Word;
    {$IFDEF WIN32}
    wPar: WParam;
    {$ELSE}
    wPar: Word;
    {$ENDIF}
    CBPrint: ^TCBPrint;
    Result: Longint;
  end;



type
  TCBCustomControlTest = class(TCustomControl)
  protected
  		procedure Paint; override;
		procedure CBPrint(var msg: TWPrintMes); message CB_PRINT;
  published
  		property Brush;
      property Font;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CBSuite', [TCBCustomControlTest]);
end;

procedure TCBCustomControlTest.Paint;
begin
 	inherited Paint;

   with Canvas do begin
   	Font.Assign(Font);
   	Brush.Assign(Brush);
   	Rectangle( 0,0,Width,Height);
   	MoveTo(0,0);
   	LineTo(Width,Height);
   	MoveTo(Width,0);
   	LineTo(0,Height);
   	TextOut (2, Height div 2 , 'Hi there, My Parent is a TCustomControl');
	end;

end;

procedure TCBCustomControlTest.CBPrint(var msg: TWPrintMes);
var
   Point: TPoint;
begin
   Point.X := msg.CBPrint^.Point.x;
   Point.y := msg.CBPrint^.Point.y;

   with msg.CBPrint^.Gdi do begin
   	SetFinalFont (Font);
   	SetBrushPrivate(Brush);
   	DFillRect( Rect(0,0,Width,Height), Point);
   	DDrawRectangle( 0,0,Width,Height, Point);
   	DDrawLine(0,0,Width,Height,Point);
   	DDrawLine(Width,0,0,Height,Point);
   	DDrawTheText (2, Height div 2 , 'Hi there, My Parent is a TCustomControl', msg.CBPrint^.Point);
   end;

end;


end.
